/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.ai;

import com.flemmli97.improvedmobs.utils.ItemAI;
import com.flemmli97.improvedmobs.utils.ItemAITasks;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import org.apache.commons.lang3.tuple.Pair;

public class ItemUseGoal
extends Goal {
    private final MobEntity living;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private ItemAI ai;
    private Hand hand;
    private ItemStack stackMain;
    private ItemStack stackOff;

    public ItemUseGoal(MobEntity entity, float maxDistance) {
        this.living = entity;
        float follow = maxDistance;
        if (entity.func_110148_a(Attributes.field_233819_b_) != null) {
            follow = (float)entity.func_110148_a(Attributes.field_233819_b_).func_111126_e();
        }
        maxDistance = Math.min(follow - 3.0f, maxDistance);
        this.maxAttackDistance = maxDistance * maxDistance;
    }

    public boolean func_75250_a() {
        LivingEntity target = this.living.func_70638_az();
        if (target == null || !target.func_70089_S() || target.func_70681_au().nextInt(10) != 0) {
            return false;
        }
        Pair<ItemAI, Hand> pair = ItemAITasks.getAI(this.living);
        this.ai = (ItemAI)pair.getKey();
        this.hand = (Hand)pair.getValue();
        return this.ai != null;
    }

    public void func_75249_e() {
        this.func_220684_a(this.ai.type() != ItemAI.ItemType.NONSTRAFINGITEM ? EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK) : EnumSet.noneOf(Goal.Flag.class));
        this.stackMain = this.living.func_184614_ca();
        this.stackOff = this.living.func_184592_cb();
    }

    public boolean func_75253_b() {
        LivingEntity target = this.living.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (this.stackMain != this.living.func_184614_ca() || this.stackOff != this.living.func_184592_cb()) {
            Pair<ItemAI, Hand> pair = ItemAITasks.getAI(this.living);
            this.ai = (ItemAI)pair.getKey();
            this.hand = (Hand)pair.getValue();
        }
        return this.ai != null;
    }

    public void func_75251_c() {
        this.seeTime = 0;
        this.attackTime = -1;
        this.living.func_184602_cy();
        this.ai = null;
        this.stackMain = null;
        this.stackOff = null;
        this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
    }

    public void func_75246_d() {
        if (this.living.getPersistentData().func_74764_b("improvedmobs:trigger_shield") && this.living.func_184586_b(this.hand).isShield((LivingEntity)this.living)) {
            this.living.getPersistentData().func_82580_o("improvedmobs:trigger_shield");
            this.attackTime = this.ai.cooldown() * 2;
            return;
        }
        LivingEntity target = this.living.func_70638_az();
        if (target != null) {
            boolean flag = this.living.func_70635_at().func_75522_a((Entity)target);
            if (this.ai.type() == ItemAI.ItemType.STRAFINGITEM) {
                this.moveStrafing(target, flag);
            } else if (this.ai.type() == ItemAI.ItemType.STANDING) {
                this.moveToRange(target, flag);
            }
            if (this.living.func_184587_cr() || !this.ai.useHand()) {
                if (!flag && this.seeTime < -60) {
                    this.living.func_184602_cy();
                    this.ai.onReset(this.living, this.hand);
                } else if (flag) {
                    if (this.ai.useHand()) {
                        int i = this.living.func_184612_cw();
                        if (i >= this.ai.maxUseCount(this.living, this.hand)) {
                            this.living.func_184597_cx();
                            this.ai.attack(this.living, target, this.hand);
                            this.attackTime = this.ai.cooldown();
                        }
                    } else if (--this.attackTime <= 0) {
                        this.ai.attack(this.living, target, this.hand);
                        this.living.func_184597_cx();
                        this.attackTime = this.ai.cooldown();
                    }
                }
            } else if (--this.attackTime < 0 && this.seeTime >= -60) {
                this.living.func_184598_c(this.hand);
            }
        }
    }

    private void moveStrafing(LivingEntity target, boolean canSee) {
        boolean flag1;
        double dist = this.living.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        boolean bl = flag1 = this.seeTime > 0;
        if (canSee != flag1) {
            this.seeTime = 0;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        if (dist <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.living.func_70661_as().func_75499_g();
            ++this.strafingTime;
        } else {
            this.living.func_70661_as().func_75497_a((Entity)target, 1.0);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.living.func_70681_au().nextFloat() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.living.func_70681_au().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (dist > (double)this.maxAttackDistance * 0.75) {
                this.strafingBackwards = false;
            } else if (dist < (double)this.maxAttackDistance * 0.25) {
                this.strafingBackwards = true;
            }
            this.living.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.living.func_70625_a((Entity)target, 30.0f, 30.0f);
        } else {
            this.living.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        }
    }

    private void moveToRange(LivingEntity target, boolean canSee) {
        double dist = this.living.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (dist <= (double)this.maxAttackDistance && this.seeTime >= 5) {
            this.living.func_70661_as().func_75499_g();
        } else {
            this.living.func_70661_as().func_75497_a((Entity)target, 1.0);
        }
        this.living.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
    }
}

